//------------------------------------------------------------------------------
// Persistence of Vision Ray Tracer Scene Description File
// File: IRTC The City 0005.pov
// Vers: 3.1g
// Desc: The 'Third-World' City
// Date: 24/04/2000
// Auth: Tony Vrnjas
// Mail: tonyv@iafrica.com
//
//------------------------------------------------------------------------------
// To Do List
//   * complete
//   - partially complete
//
//* 1. Use corrugated #macro on all shacks (quick & dirty single piece per side).
//* 2. Overhead pass guard-rail poles in a different texture.
//* 3. Building One windows to be recessed (or done differently).
//- 4. Kerbs along all roads - start with front road.
//- 5. Pavements - with paving slabs.
//* 6. Use heightfield for ground under overpass.
//* 7. Path over ground to gap in fence.
//- 8. Drop the level of the roads so that kerbs can be added.
//* 9. Doors for the shacks.
//*10. At least one shack to have a window.
//*11. Lights in all the shacks?
// 12. A normal on the texture of City Building One?
//-13. White lines and other markings on the roads, esp. front road.
// 14. Sculpt the flyover a little, esp. bottom.
//*15. Buttresses (?) to hold flyover - right side (?).
//-16. Chairs, stools, tables, bicycle, bits of cars
// 17. Rubbish, plastic bags, rocks, stones.
// 18. Rocks on roofs of shacks to keep down in wind.
// 19. Make gap between flyover slabs smaller.
//*20. Change starting point of near-side kerb to fall between paving stones.
//*21. Change ShackOne to a sloping roof.
//*22. Flyover railings on far side.
//*23. Light pole on flyover.
//*24. Light pole on nearside road.
//-25. Lights on all streets.
// 26. Switch that makes the whole scene a night scene.
//*27. Soften/colour the light to more represent an early Sunday morning scene.
//-28. Change all visible shack walls - made up of pieces of corrugated iron.
// 29. Reflections of birds in CityBuildingOne windows.
//*30. Take camera out of CityBuildingThree. 
// 31. Potholes.
// 32. Hawkers' wares - neatly arranged apples, etc.
//*33. Make the lamp post lights a little yellower.
//*34. Door on shack three.
// 35. Quick 'n dirty Washline.
//*36. Change 'Rust' texture.
//*37. Re-do stop sign.
//
//------------------------------------------------------------------------------
// Global Settings
#version 3.1;
#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "metals.inc"
#include "citytex.inc"
#include "cityobj.inc"

// Assumed_gamma values of 1.4 and 1.8 actually make the picture seem darker and
// better contrast.
global_settings {
  assumed_gamma 1.0
}
//------------------------------------------------------------------------------
// Development Settings
// --------------------
#declare UseFlyOverRoad = yes;
#declare UseNearRoad = yes;
#declare UseCityBuildingOne = yes;
#declare UseCityBuildingTwo = yes;
#declare UseCityBuildingThree = yes;
#declare UseAllShacks = yes;

#declare UseShackOneLights = no;
#declare UseShackTwoLights = yes;
#declare UseShackThreeLights = no;
#declare UseShackFourLights = yes; //default = yes
#declare UseShackFiveLights = no;
#declare UseShackSixLights = yes; //default = yes

#declare UseReferencePoints = no;
#declare UseOverheadCamera = no;

// Reference points
#if (UseReferencePoints = yes)
  cylinder {
    <0,10,0>,<0,-1,0>,0.05
    pigment { colour Red }
  }
  cylinder {
    <-10,10,0>,<-10,-1,0>,0.05
    pigment { colour Red }
  }
  cylinder {
    <10,10,0>,<10,-1,0>,0.05
    pigment { colour Red }
  }
#end

//------------------------------------------------------------------------------
#if (UseOverheadCamera = no)
  camera {
    location  <0.0, 1.8, -13.0>
    direction 1.5*z
    right     16/9*x
    look_at   <-1.0, 1.6, 10.0> // gap in wall
  }
#else
  camera {
//    location  <0.0, 100.0, 0.0>
    location  <0.0, 30.0, 0.0>
    direction 1.5*z
    right     16/9*x
    look_at   <0.0, 0.0,  0.0>
  }
#end  

sky_sphere {
  pigment {
    gradient y
    colour_map {
      [0.0 colour blue 0.4]
      [1.0 colour rgb 1]
    }
  }
}

light_source {
  <0,0,0>
  colour red 0.95  green 1.0  blue 0.90
  translate <-20000, 10000, -30000>
}

//------------------------------------------------------------------------------
// Temporary plane for ground
// (still used on far side pavements)
plane { y, -0.5 
  pigment { colour Khaki }
}

//------------------------------------------------------------------------------
// Heightfield for shack area
height_field {
  png
  "ShackFloorPath03.png"
  inverse
  pigment {colour DarkBrown}
  smooth
  scale <40,0.2,10.56>
  translate <-20,-0.05,-2.0>
}
//------------------------------------------------------------------------------
// Nearside Pavement
#declare PaveRotate1 = seed(700);
#declare PaveRotate2 = seed(800);
#declare PaveRotate3 = seed(900);
#declare CountX = -10;
#while (CountX < 10)
  #declare CountZ = 0;
  #while (CountZ > -2)
    box {<CountX,0.0,CountZ><CountX+0.38,0.05,CountZ-0.38>
      texture {PavingStone}
        rotate <0.5-(rand(PaveRotate1)/1),0.5-(rand(PaveRotate2)/1),0.5-(rand(PaveRotate3)/1)>
    }
    #declare CountZ = CountZ - 0.40;
  #end
  #declare CountX = CountX + 0.40;
#end

// Nearside kerbstones
#declare CountX = -10.20;
#while (CountX < 10)
  box {<CountX,-0.25,-2.0><CountX+0.78,0.05,-2.2>
    texture {KerbStone}
  }
  #declare CountX = CountX + 0.80;
#end  

//------------------------------------------------------------------------------
// Near side stop sign
object { StopSign
  rotate <0,90,0>
  translate <-0.75,0.0,-1.75>
}
// Near near side Stop sign
object { StopSign
  rotate <0,-90,0>
  translate <3.75,0.0,-10.25>
}

//------------------------------------------------------------------------------
// Lamp Posts
// Lamp Posts - Nearside road
object {MakeLampPost1 (rgb <0.4, 0.4, 0.35>,5,2,LampPostTexture)
  rotate <0,180,0>
  translate <3,0,-1.6>
}
object {MakeLampPost1 (rgb <0.4, 0.4, 0.35>,5,2,LampPostTexture)
  rotate <0,180,0>
  translate <-22,0,-1.6>
}

// Lamp Posts - Flyover
object {MakeLampPost1 (rgb <0.5, 0.5, 0.42>,9,2,LampPostTexture)
  rotate <0,0,0>
  translate <-8,3.8,0.4>
}
object {MakeLampPost1 (rgb <0.5, 0.5, 0.42>,9,2,LampPostTexture)
  rotate <0,0,0>
  translate <22,4.8,0.4>
}

// Lamp Posts - other side of shacks
object {MakeLampPost1 (rgb <0.4, 0.4, 0.35>,5,2,LampPostTexture)
  rotate <0,0,0>
  translate <3,0,9.6>
}

//------------------------------------------------------------------------------
// Define the shacks
// From left to right: Four,  Six,  Two,    One,   Three, Five
//        old colours: Brown, Pink, Yellow, Green, Red,   Blue 
//
// Shack One - Green
#declare ShackOne = 
union {
  #if (UseShackOneLights = yes)
    light_source { <2.5,1,1.5>
      colour red 0.4  green 0.2  blue 0.2
      fade_distance 5
      fade_power 2
    }
  #end  
  union {
    difference {
      object {MakeSheet(3,2,0.010,20,3*5)}
      box {<0.1,-1,-1><0.8,1.7,1>}
      texture {ShackTexture3}
    }
    box {<0.15,0.05,-0.05><0.75,1.65,0.05>
      texture {Sandalwood}
    }
    cylinder {<0.20,0.90,-0.055>,<0.30,0.90,-0.055>,0.02
      texture {Chrome_Metal}
    }
    translate <0,0,-TheDepth>
  }
  object {MakeSheet(3,2,0.010,20,3*5)
    texture {ShackTexture3}
    translate <0,0,2>
  }
  object {MakeSheet(2,2,0.010,20,2*5)
    texture {ShackTexture3}
    rotate <0,90,0>
    translate <-TheDepth,0,2>
  }
  object {MakeSheet(2,2,0.010,20,2*5)
    texture {ShackTexture3}
    rotate <0,90,0>
    translate <3,0,2>
  }
  object {MakeSheet(3.3,2.6,0.010,20,4.0*5)
    texture {ShackTexture3}
    rotate <95,0,0>
    translate <-0.15,2+TheDepth+0.02,-0.4>
  }
}

// Shack Two - Yellow
#declare ShackTwo =
union {
  #if (UseShackTwoLights = yes)
    light_source { <2.5,1,1>
      colour red 0.15 green 0.1  blue 0.1
      fade_distance 5
      fade_power 2
    }
  #end
  union {
    difference {
      object {MakeSheet(3,2.1,0.005,60,3*6)}
      box {<0.1,-1,-1><0.8,1.7,1>}
      box {<1.2,0.9,-1><2.4,1.7,1>}
      texture {ShackTexture3}
    }
    box {<0.15,0.05,-0.05><0.75,1.65,0.05>
      texture {Yellow_Pine}
    }
    cylinder {<0.20,0.90,-0.055>,<0.30,0.90,-0.055>,0.02
      texture {Chrome_Metal}
    }
    box {<1.2,0.9,0><2.4,1.7,0.01>
      texture {ShackWindow}
    }
    translate <0,0,-TheDepth>
  }
  object {MakeSheet(3,2.1,0.005,60,3*6)
    texture {ShackTexture3}
    translate <0,0,2.5>
  }
  object {MakeSheet(2.5,2.1,0.005,60,2.5*6)
    texture {ShackTexture3}
    rotate <0,90,0>
    translate <-TheDepth,0,2.5>
  }
 object {MakeSheet(2.5,2.1,0.005,60,2.5*6)
    texture {ShackTexture3}
    rotate <0,90,0>
    translate <3,0,2.5>
  }
  object {MakeSheet(3.4,2.9,0.010,60,4*4)
    texture {ShackTexture3}
    rotate <90,0,0>
    translate <-0.2,2.1+TheDepth,-0.2>
  }
}

// Shack Three - Red
#declare ShackThree =
union {
  #if (UseShackThreeLights = yes)
    light_source { <1,1,1>
      colour red 0.6  green 0.1  blue 0.3
      fade_distance 6
      fade_power 2
    }
  #end
  object {MakeSheet(4,2.5,0.005,45,4*7) // near wall
    texture {ShackTexture2}
    translate <0,0,-TheDepth>
  }
  object {MakeSheet(4,2.5,0.005,45,4*7) // far wall
    texture {ShackTexture2}
    translate <0,0,3>
  }
  union {
    difference {
      object {MakeSheet(3,2.5,0.005,45,3*7)} // left wall
      box {<2.1,-1,-1><2.9,1.9,1>}
      texture {ShackTexture2}
    }
    box {<2.15,0.05,-0.05><2.85,1.85,0.05>
      texture {Sandalwood}
    }    
    cylinder {<2.20,0.95,-0.055>,<2.30,0.95,-0.055>,0.02
      texture {Chrome_Metal}
    }
    rotate <0,90,0>
    translate <-TheDepth,0,3>
  }
  object {MakeSheet(3,2.5,0.005,45,3*7) // right wall
    texture {ShackTexture2}
    rotate <0,90,0>
    translate <4,0,3>
  }
  object {MakeSheet(4.4,3.4,0.010,15,4.4*4) // roof
    texture {ShackTexture2}
    rotate <90,0,0>
    translate <-0.2,2.5+TheDepth,-0.2>
  }
}

// Shack Four - Brown
#declare ShackFour =
union {
  #if (UseShackFourLights = yes)
    light_source { <2.5,1,2.5>
      colour red 0.4  green 0.3  blue 0.3
      fade_distance 8
      fade_power 2
    }
  #end
  object {MakeSheet(3,2.5,0.005,30,3*7) // near wall
    texture {ShackTexture2}
    translate <0,0,-TheDepth>
  }
  object {MakeSheet(3,2.5,0.005,30,3*7) // far wall
    texture {ShackTexture2}
    translate <0,0,3>
  }
  object {MakeSheet(3,2.5,0.005,30,3*7) // left wall
    texture {ShackTexture2}
    rotate <0,90,0>
    translate <-TheDepth,0,3>
  }
  difference {
    object {MakeSheet(3,2.5,0.005,30,3*7)} // right wall
    box {<0.1,-1,-1><1.0,2.0,1>}
    texture {ShackTexture2}
    rotate <0,90,0>
    translate <3,0,3>
  }
  object {MakeSheet(3.4,3.4,0.005,60,3.4*3) // roof
    texture {ShackTexture2}
    rotate <90,0,0>
    rotate <0,90,0>
    translate <-0.2,2.5+TheDepth,3.2>
  }
}

// Shack Five - Blue
#declare ShackFive =
union {
  #if (UseShackFiveLights = yes)
    light_source { <3,1,1>
      colour red 0.5  green 0.0  blue 0.3
      fade_distance 5
      fade_power 2
    }
  #end
  union {
    object {MakeSheet(1.0,2.2,0.005,30,1*7)
      texture {ShackTexture1 rotate <45,45,45>}
      translate <0,0,0>
    }
    object {MakeSheet(1.0,2.2,0.005,30,1*7)
      texture {ShackTexture1 rotate <30,30,30>}
      translate <0.9,0,0>
    }
    object {MakeSheet(1.0,2.2,0.005,30,1*7)
      texture {ShackTexture1 rotate <60,60,60>}
      translate <1.7,0,0>
    }
    object {MakeSheet(1.0,2.2,0.005,30,1*7)
      texture {ShackTexture1 rotate <5,5,5>}
      translate <2.5,0,0>
    }
    translate <0,0,-TheDepth>
  }
  object {MakeSheet(3.5,2.2,0.005,30,3.5*7) // far wall
    texture {ShackTexture1}
    translate <0,0,3.5>
  }
  union {
    difference {
      object {MakeSheet(3.7,2.2,0.005,30,3.7*7)} // left wall
      box {<2.6,-1,-1><3.4,1.9,1>}
      texture {ShackTexture1}
    }
    box {<2.65,0.10,-0.05><3.35,1.85,0.05>
      texture {Yellow_Pine}
    }
    cylinder {<2.75,0.80,-0.055>,<2.85,0.80,-0.055>,0.02
      texture {Chrome_Metal}
    }
    rotate <0,90,0>
    translate <-TheDepth,0,3.6>
  }
  object {MakeSheet(3.7,2.2,0.005,30,3.7*7) // right wall
    texture {ShackTexture1}
    rotate <0,90,0>
    translate <3.5,0,3.6>
  }
  object {MakeSheet(4.0,4.0,0.005,30,4.0*7) // roof
    texture {ShackTexture1}
    rotate <90,0,0>
    rotate <0,90,0>
    translate <-0.2,2.2+TheDepth,3.8>
  }
}

// Shack Six - Pink
#declare ShackSix =
union {
  #if (UseShackSixLights = yes) 
    light_source { <2.5,1,1.5>
      colour red 0.25  green 0.2  blue 0.2
      fade_distance 6
      fade_power 2
    }
  #end
  difference {
    object {MakeSheet(4,2.2,0.005,20,4*6)}
    box {<2.9,-1,-1><3.7,1.9,1>}
    texture {ShackTexture1}
    translate <0,0,-TheDepth>
  }
  object {MakeSheet(4,2.2,0.005,20,4*6)
    texture {ShackTexture1}
    translate <0,0,2>
  }
  object {MakeSheet(2,2.2,0.005,20,2*6)
    texture {ShackTexture1}
    rotate <0,90,0>
    translate <-TheDepth,0,2>
  }
  object {MakeSheet(2,2.2,0.005,20,2*6)
    texture {ShackTexture1}
    rotate <0,90,0>
    translate <4,0,2>
  }
  object {MakeSheet(4.8,2.8,0.010,20,4*4)
    texture {ShackTexture1}
    rotate <90,0,0>
    translate <-0.4,2.2+TheDepth,-0.4>
  }
}

//------------------------------------------------------------------------------
// Place the shacks
#if (UseAllShacks = yes)
  object {ShackOne
    translate <0,0,6.3>
  }
  object {ShackTwo
    translate <-5,0,5.8>
  }
  object {ShackThree
    translate <3.40,0.00,5.20>
  }
  object {ShackFour
    rotate <0,-3.5,0>
    translate <-10,0,2>
  }
  object {ShackFive
    rotate <0,-3.5,0>
    translate <4.6,0,1.05>
  }
  object {ShackSix
    rotate <0,-10,0>
    translate <-9.7,0,5.6>
  }
#end
//------------------------------------------------------------------------------
// Scatter some objects around the scene
//
// Pine Stools in front of second shack
object {PineStool translate <-5.8,0,5.0>} 
object {PineStool translate <-6.1,0,5.4>}
object {PineStool translate <-5.5,0,5.5>}

// Pine table in front of first shack
object {PineTable rotate <0,90-3.5,0> translate <-6.6,0,3>}

// Cool-drink can near stop sign
cylinder {<-1.0,0.03,0.2>,<-1.11,0.03,0.2>,0.03 texture {CanTextureBlue}}

// Cool-drink cans next to the kerb stones
cylinder {<-2.0,-0.12,-2.23>,<-2.11,-0.12,-2.23>,0.03 texture {CanTextureRed}}
cylinder {<-2.7,-0.12,-2.23>,<-2.81,-0.12,-2.23>,0.03 texture {CanTextureBlue}}
cylinder {<-3.4,-0.12,-2.23>,<-3.41,-0.12,-2.34>,0.03 texture {CanTextureRed}}
cylinder {<-3.6,-0.15,-2.23>,<-3.60,-0.04,-2.23>,0.03 texture {CanTextureRed}}

//------------------------------------------------------------------------------
// Define and place a precast concrete wall behind the shacks.

#declare WallSlab1 =
union {
  box {<0,0.27,0.01><1.50,0.29,0.03>}
  box {<0,0.02,0><1.50,0.27,0.04>}
  box {<0,0,0.01><1.50,0.02,0.03>}
}
#declare WallTexture =
texture {
  T_Stone41
//  T_Stone35
}
// Array declaration for wall slab location
#declare SlabHere =
array[6][54] {
  {0,0,0,0,1,1,1,1,0,0,0,0,0,1,1,1,0,0,0,0,0,1,1,1,0,0,0,0,0,0,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0},
  {1,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0},
  {1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
  {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
  {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
  {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1}
 }

// Another brick in the wall
union {
  #declare RandTex4 = seed(4);
  #declare RandTex5 = seed(5);
  #declare RandTex6 = seed(6);
  #declare CountX = 0;
  #while (CountX < 6)
    #declare CountY = 0;
    #while (CountY < 54)
      box {<-30+(CountY*1.56),-0.1,8.5><-30+(CountY*1.56)+0.12,1.9,8.62>
        texture {WallTexture
          rotate <90-(180*rand(RandTex4)),90-(180*rand(RandTex5)),90-(180*rand(RandTex6))>
        }
      }
      #if (SlabHere[CountX][CountY]=0)
      #else
        object {WallSlab1
          translate <-30+0.06+(CountY*1.56)+.03,((5-CountX)*0.30),8.54>
          texture {WallTexture
            rotate <90-(180*rand(RandTex4)),90-(180*rand(RandTex5)),90-(180*rand(RandTex6))>
          }
        }
      #end
      #declare CountY = CountY + 1;
    #end
    #declare CountX = CountX + 1;
  #end
}

//------------------------------------------------------------------------------
// Flyover Road Declarations
//
#declare ConcreteTexture =
texture {
   T_Stone44
   scale 2
}                     
#declare SafetyRailTexture =
texture {
  pigment {Candy_Cane}
}
texture {
  pigment {
    marble
    turbulence 0.8
    colour_map { 
      [0.0  colour Black filter 0.4]
      [0.5  colour White filter 0.7]
      [0.8  colour White filter 0.7]
      [1.0  colour Black filter 0.5]
    }    
    rotate <0,0,0>
    scale 0.5
  }
}  
#declare SafetyRailPoleTexture =
texture {
//  Rusty_Iron
  pigment {
    colour Gray25
  }
  finish {
    metallic
    reflection 0.1
  }
//  scale 0.3
}

#declare FlyOverRoad =
union {
  difference {
    box {<0,0.2,0><200,1,8>}
    box {<-1,0.50,-1><201,0.70,0.15>}
    #declare CountX = 1;
    #while (CountX < 200)
       box {<CountX,-1,-1><CountX + 0.06,2,9>}
       #declare CountX = CountX + 4;
    #end
  }
  #declare CountX = 3;
  union {
    #while (CountX < 200)
      cylinder {<CountX,0.9,0.20>,<CountX,1.45,0.20>,0.06
        texture {SafetyRailPoleTexture}
      }
      cylinder {<CountX,0.9,7.80>,<CountX,1.45,7.80>,0.06
        texture {SafetyRailPoleTexture}
      }
      #declare CountX = CountX + 4;
    #end
    union {
      box {<0,1.09,0.25><200,1.21,0.27>}
      box {<0,1.29,0.25><200,1.41,0.27>}
      texture { SafetyRailTexture
      }
    }
    union {
      box {<0,1.09,7.75><200,1.21,7.73>}
      box {<0,1.29,7.75><200,1.41,7.73>}
      texture { SafetyRailTexture
      }
    }
  }
  texture {ConcreteTexture}
  scale <1/200,1/1,1/8>
}


// Flyover Road
#if (UseFlyOverRoad = yes)
  object {FlyOverRoad
    scale <200,1,8>
    rotate <0,0,1.25>
//    translate <-100,1.5,0>
    translate <-100,0.90,0>
  }
#end

// Flyover Base
#declare FlyOverBase =
difference {
  union {
    cone { <0,3.7,0>, 4, <0,0,0>, 0 }
    cone { <0,3.7,0>, 2.5, <0,0,0>, 1.5 }
  }
  box {<-8,-1,-8><-0.5,4,8>}
  box {<0.5,-1,-8><8,4,8>}
}
object {FlyOverBase
  texture {ConcreteTexture}
  translate <8.5,0,4>
}
object {FlyOverBase
  texture {ConcreteTexture}
  translate <-11.5,-0.2,4>
}

// Far Road
box {
  <-100,0,10><100,0.01,18>
  scale <1,1,1>
  rotate <0,0,0>
  translate <0,0,0>
  texture { RoadSurface2 }
}

// Road between buildings
box {
  <-21,0,11><-13,0.01,150>
  scale <1,1,1>
  rotate <0,0,0>
  translate <0,0,0>
  texture { RoadSurface2 }
}

// Near Road
#if (UseNearRoad = yes)
  box {
    <-100,-0.15,-2><100,-0.21,-10>
    scale <1,1,1>
    rotate <0,0,0>
    translate <0,0,0>
    texture { RoadSurface2 }
  }

// Stop lines on road
  box {<-15,-0.15,-6.10><0,-0.149,-5.90> texture {RoadPaintWhite}}
  box {<3,-0.15,-6.10><15,-0.149,-5.90>  texture {RoadPaintWhite}}
  box {<0,-0.15,-2.5><-0.50,-0.149,-6.0> texture {RoadPaintWhite}}
  box {<3,-0.15,-9.5><3.5,-0.149,-6.0>   texture {RoadPaintWhite}}

// Zebra Crossing
  #declare CountZ = -2.25;
  #while (CountZ > -10)
    box {
      <0.5,-0.15,CountZ><2.5,-0.149,CountZ-0.5> 
      texture {RoadPaintWhite}
    }
    #declare CountZ = CountZ - 1;
  #end
#end

//-------------------------------------------
// City Building One Declarations
//
#declare StoneBuildingOne =
texture {
  T_Stone22
}
#declare GlassBuildingOne =
texture {
//  Glass2
  Soft_Silver
}
#declare CityBuildingOne =
union {
  // Recesses for front windows
  difference {
    box {<0,0,0><100,50,50>}
    #declare CountX = 2;
    #while (CountX < 94)
      #declare CountY = 5;
      #while (CountY < 47)
        box {<CountX,CountY,-0.05><CountX + 3,CountY + 2,0.50>}
        #declare CountY = CountY + 3;
      #end
      #declare CountX = CountX + 5;
    #end
    #declare CountX = 2;
    #while (CountX < 94)
       box {<CountX,0,-0.05><CountX + 6.5,3,0.50>}
       #declare CountX = CountX + 7;
    #end
    texture { StoneBuildingOne }
  }
  // Front windows
  #declare WindowMove1 = seed(1);
  #declare WindowMove2 = seed(2);
  #declare WindowMove3 = seed(3);
  #declare CountX = 2;
  #while (CountX < 94)
     #declare CountY = 5;
     #while (CountY < 47)
//       box {<CountX,CountY,-0.05><CountX + 3,CountY + 2,0.10>
       box {<CountX,CountY,0.40><CountX + 3,CountY + 2,0.50>
         texture {GlassBuildingOne}
         rotate <0.05-(rand(WindowMove1)/10),0.05-(rand(WindowMove2)/10),0.05-(rand(WindowMove3)/10)>
       }
       #declare CountY = CountY + 3;
     #end
     box {<CountX + 3.5,4,-0.50><CountX + 4.5,50,0.10>
       texture { StoneBuildingOne
       }
     }
     #declare CountX = CountX + 5;
  #end
  // Side Windows
  #declare CountZ = 2;
  #while (CountZ < 44)
     #declare CountY = 5;
     #while (CountY < 47)
       box {<-0.10,CountY,CountZ><0.05,CountY + 2,CountZ + 3>
         texture {GlassBuildingOne}
         rotate <0.05-(rand(WindowMove1)/10),0.05-(rand(WindowMove2)/10),0.05-(rand(WindowMove3)/10)>
       }
       #declare CountY = CountY + 3;
     #end
     box {<-0.50,4,CountZ + 3.5><0.10,50,CountZ + 4.5>
       texture { StoneBuildingOne
       }
     }
     #declare CountZ = CountZ + 5;
  #end
  // Ground floor front windows. None on side.
  #declare CountX = 2;
  #while (CountX < 94)
//     box {<CountX,0,-0.05><CountX + 6.5,3,0.10>
     box {<CountX, 0.00, 0.40><CountX + 6.50, 3.00, 0.50>
       texture {GlassBuildingOne}
     }
     #declare CountX = CountX + 7;
  #end
  // Front pavement overhang
  box { <-2.5,3.8,0><102.5,4.1,-2.5>
    texture { StoneBuildingOne }
  }
  // Side pavement overhang
  box { <-2.5,3.8,-2.5><0,4.1,52.5>
    texture { StoneBuildingOne }
  }
  scale <1/100,1/50,1/50>
}


//-------------------------------------------
// City Building Two Declarations
//
#declare StoneBuildingTwo =
texture {
  T_Stone15
}
#declare GlassBuildingTwo =
texture {
//  Glass2
  Soft_Silver
}
#declare CityBuildingTwo =
union {
  box {<0,0,0><50,150,50>
    texture { StoneBuildingTwo }
  }
  // Front Windows
  #declare WindowMove1 = seed(1);
  #declare WindowMove2 = seed(2);
  #declare WindowMove3 = seed(3);
  #declare CountX = 2;
  #while (CountX < 47)
     #declare CountY = 4;
     #while (CountY < 147)
       box {<CountX,CountY,-0.05><CountX + 1.5,CountY + 2,0.10>
         texture {GlassBuildingTwo}
         rotate <0.05-(rand(WindowMove1)/10),0.05-(rand(WindowMove2)/10),0.05-(rand(WindowMove3)/10)>
       }
       #declare CountY = CountY + 2.5;
     #end
     #declare CountX = CountX + 2;
  #end
  //Side Windows
  #declare CountZ = 2;
  #while (CountZ < 47)
     #declare CountY = 0;
     #while (CountY < 147)
       box {<49.95,CountY,CountZ><50.10,CountY + 2,CountZ + 1.5>
         texture {GlassBuildingTwo}
         rotate <0.05-(rand(WindowMove1)/10),0.05-(rand(WindowMove2)/10),0.05-(rand(WindowMove3)/10)>
       }
       #declare CountY = CountY + 2.5;
     #end
     #declare CountZ = CountZ + 2;
  #end
  texture {StoneBuildingTwo}
  scale <1/50,1/150,1/50>
}

// City Building One
#if (UseCityBuildingOne = yes)
  object {CityBuildingOne
    rotate <0,0,0>
    scale <100,50,50>
    translate <-10,0,21>
  }
#end

// City Building Two
#if (UseCityBuildingTwo = yes)
  object {CityBuildingTwo
    rotate <0,0,0>
    scale <50,50,50>
    translate <-74,0,21>
  }
#end

// City Building Three
#if (UseCityBuildingThree = yes)
  difference {
    box {
      <0,0,0><1,1,1>
      rotate <0,0,0>
      scale <200,20,20>
      translate <-100,0,-33>
    }
    box {<-1.00,2.80,-12.00><1.00,0.80,-14.00>}
    texture {
      pigment { Pink_Granite }
    }
  }
#end

